(function() {
  //farmerswife.com , 26/03/2014 Rafa Dorado
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'collections/project/ProjectCollection', 'collections/contacts/ContactCollection', 'models/project/ProjectModel', 'models/contact/ContactModel', 'views/project/ProjectDetailView', 'views/contact/ContactView', 'views/todo/FormTodoView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, ProjectCollection, ContactCollection, ProjectModel, ContactModel, ProjectDetailView, ContactView, FormTodoView) {
    var TodoDetailView;
    return TodoDetailView = class TodoDetailView extends Backbone.View {
      initialize(usr, todo) {
        this.usr = usr;
        this.todo = todo;
        this.todo.on('todoFilled', this.update_todo, this);
        return this.todo.on('todoFieldChanged', this.update_field_todo, this);
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap #id-todo-project': 'btnProjectClicked',
          'tap #id-btn-todo-completed': 'btnTodoCompletedClicked',
          'tap #id-btn-todo-declined': 'btnTodoDeclinedClicked',
          'tap #id-todo-assigned-to': 'btnAssignedToClicked',
          'tap .edit-replyNote': 'btnShowReplyNoteForm',
          'tap #id-btn-todo-done-replyNote': 'btnSaveReplyNoteClicked',
          'tap #id-btn-edit-todo': 'btnEditTodoClicked',
          'pageshow': 'update_todo'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['TodoDetailView'];
        if (this.todo.get('forDate') && this.todo.get('forDateAndTime')) {
          this.todo.unset('forDate'); //DIRTY HACK TO AVOID DUPLICATED DATE FORMATS :/
        }
        this.$el.html(template({
          todo: this.todo.toJSON()
        }));
        this.$el.find('#id-spinner-all').hide();
        this.addSidePanel();
        return this.$el.attr('id', 'id-TodoDetailView');
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnEditTodoClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        this.todo.on('todoStructureChanged', this.__go_to_todo_form_view, this);
        return this.todo.get_todo_structure(this.usr);
      }

      __go_to_todo_form_view() {
        var view;
        if (!FormTodoView) {
          FormTodoView = require('views/todo/FormTodoView');
        }
        view = new FormTodoView(this.usr, this.todo, 'edit');
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnShowReplyNoteForm(event) {
        event.preventDefault();
        event.stopPropagation();
        return $('#id-div-form-replyNote').show();
      }

      btnSaveReplyNoteClicked(event) {
        var note;
        event.preventDefault();
        event.stopPropagation();
        note = this.$el.find('#id-input-todo-replyNote').val();
        return this.todo.set_todo_replyNote(this.usr, note);
      }

      btnProjectClicked(event) {
        var btn, proj, projCol, projectID, view;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        projectID = btn.attr('data-projectID');
        if (!ProjectModel) {
          ProjectModel = require('models/project/ProjectModel');
        }
        if (!ProjectCollection) {
          ProjectCollection = require('collections/project/ProjectCollection');
        }
        if (!ProjectDetailView) {
          ProjectDetailView = require('views/project/ProjectDetailView');
        }
        proj = new ProjectModel();
        projCol = new ProjectCollection().fetch();
        proj.get_project_detail(this.usr, projectID);
        view = new ProjectDetailView(this.usr, proj, projCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnTodoCompletedClicked(event) {
        var btn, completed;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        completed = btn.attr('data-completed');
        if (completed === '1') {
          completed = '0';
        } else {
          completed = '1';
        }
        return this.todo.set_todo_isdone(this.usr, completed);
      }

      btnTodoDeclinedClicked(event) {
        var btn, declined;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        declined = btn.attr('data-declined');
        if (declined === '1') {
          declined = 0;
        } else {
          declined = 1;
        }
        return this.todo.set_todo_isdeclined(this.usr, declined);
      }

      btnAssignedToClicked(event) {
        var btn, contact, contactCol, userID, view;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        userID = btn.attr('data-userid');
        if (!ContactView) {
          ContactView = require('views/contact/ContactView');
        }
        if (!ContactModel) {
          ContactModel = require('models/contact/ContactModel');
        }
        if (!ContactCollection) {
          ContactCollection = require('collections/contacts/ContactCollection');
        }
        contact = new ContactModel();
        contact.get_details_contact(this.usr.get('sessionID'), userID);
        contactCol = new ContactCollection();
        view = new ContactView(this.usr, contact, contactCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      update_field_todo(event) {
        return this.update_todo(true);
      }

      update_todo(forceUpdate) {
        var completed, created, declined, dt, note, projectID, replyNote, title;
        if (this.todo.changedAttributes() || forceUpdate === true) {
          this.$el.find('#id-spinner-all').hide();
          completed = this.todo.get('isDone');
          declined = this.todo.get('declined');
          projectID = this.todo.get('projectID');
          created = this.todo.get('created');
          replyNote = this.todo.get('replyNote');
          title = this.todo.get('title');
          note = this.todo.get('note');
          //title
          this.$el.find("#id-p-title").text(title);
          //Note
          this.$el.find('#id-p-note').text(note);
          //date
          if (this.todo.get('forDate')) {
            this.$el.find('#id-btn-todo-date').find('.ui-btn-text').text(Handlebars.helpers.beautyDateForTodos(this.todo.get('forDate')));
          } else {
            if (this.todo.get('alarmMinutesBefore')) {
              dt = Handlebars.helpers.beautyDateAndTimeForTodos(this.todo.get('forDateAndTime'), this.todo.get('alarmMinutesBefore'));
            } else {
              dt = Handlebars.helpers.beautyDateAndTimeForTodos(this.todo.get('forDateAndTime'));
            }
            this.$el.find('#id-btn-todo-date').find('.ui-btn-text').text(dt);
          }
          //Project
          this.$el.find('#id-todo-project').attr('data-projectID', projectID);
          //COMPLETED
          if (completed === 1 || completed === "1") {
            this.$el.find('#id-div-todo-completed').html('<a href="#" id="id-btn-todo-completed" data-role="button" data-completed="1" class="btnTodoCompleted">Yes</a>');
          } else {
            this.$el.find('#id-div-todo-completed').html('<a href="#" id="id-btn-todo-completed" data-role="button" data-completed="0">No</a>');
          }
          //DECLIEND
          if (declined === 1 || declined === "1") {
            this.$el.find('#id-div-todo-declined').html('<a href="#" id="id-btn-todo-declined" data-role="button" data-declined="1" class="btnTodoDeclined">Yes</a>');
          } else {
            this.$el.find('#id-div-todo-declined').html('<a href="#" id="id-btn-todo-declined" data-role="button" data-declined="0">No</a>');
          }
          //Reply NOTE  / Comment
          this.$el.find('#id-p-replyNote').text(replyNote);
          this.$el.find("#id-div-form-replyNote").hide();
          this.$el.find("#id-p-created").text(Handlebars.helpers.beautyDate(created));
          this.$el.find('#id-todo-assigned-to').attr('data-userid', this.todo.get('assignedToID')).find("span.ui-btn-text").text(this.todo.get('assignedToUserName'));
          this.$el.find('#id-todo-assigned-to').button();
          this.$el.find('#id-btn-todo-declined').button();
          return this.$el.find('#id-btn-todo-completed').button();
        }
      }

    };
  });

}).call(this);
